<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Company extends Model 
{

    protected $table = 'companies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'code', 'group', 'address', 'location_id', 'location_name', 'status', 'attributes');

    public function Location()
    {
        return $this->hasOne('App\Models\Location');
    }

    public function users()
    {
        return $this->hasMany('App\Models\UserEmployee', 'company_id');
    }

}